<?php
require_once '../includes/auth.php';
requireAdminLogin();

// Fetch Survey Type Breakdown
$stmt = $pdo->query("SELECT survey_type, COUNT(*) as count FROM survey_responses GROUP BY survey_type");
$type_breakdown = $stmt->fetchAll();

// Fetch Daily Trend (Last 7 Days)
$stmt = $pdo->query("SELECT DATE(started_at) as date, COUNT(*) as count 
    FROM survey_responses 
    WHERE started_at >= DATE(NOW()) - INTERVAL 7 DAY 
    GROUP BY DATE(started_at) 
    ORDER BY date ASC");
$daily_trend = $stmt->fetchAll();

// Prepare Chart Data
$types_labels = [];
$types_data = [];
foreach ($type_breakdown as $row) {
    $types_labels[] = ucwords(str_replace('_', ' ', $row['survey_type']));
    $types_data[] = $row['count'];
}

$trend_labels = [];
$trend_data = [];
foreach ($daily_trend as $row) {
    $trend_labels[] = date('M d', strtotime($row['date']));
    $trend_data[] = $row['count'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Analytics - BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div class="bg-slate-800 text-white w-64 flex-shrink-0">
            <div class="p-4 text-xl font-bold border-b border-slate-700">BodhiTree Admin</div>
            <nav class="mt-4">
                <a href="dashboard.php" class="block py-3 px-4 hover:bg-slate-700">Dashboard</a>
                <a href="surveys.php" class="block py-3 px-4 hover:bg-slate-700">Surveys</a>
                <a href="analytics.php" class="block py-3 px-4 bg-slate-700 border-l-4 border-blue-500">Analytics</a>
                <a href="mentors.php" class="block py-3 px-4 hover:bg-slate-700">Mentors</a>
                <a href="responses.php" class="block py-3 px-4 hover:bg-slate-700">Responses</a>
                <a href="freebies.php" class="block py-3 px-4 hover:bg-slate-700">Freebies</a>
                <a href="logout.php" class="block py-3 px-4 hover:bg-slate-700 text-red-300">Logout</a>
            </nav>
        </div>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-8">Detailed Analytics</h1>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                <!-- Chart 1: Survey Types -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-bold text-gray-800 mb-4">Survey Type Breakdown</h3>
                    <div class="relative h-64">
                        <canvas id="typesChart"></canvas>
                    </div>
                </div>

                <!-- Chart 2: Daily Trend -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-bold text-gray-800 mb-4">Daily Completions (Last 7 Days)</h3>
                    <div class="relative h-64">
                        <canvas id="trendChart"></canvas>
                    </div>
                </div>
            </div>

            <!-- Deep Dive Metrics -->
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Deep Dive Metrics</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Willingness to Pay -->
                <div class="bg-white rounded-lg shadow p-6 border-t-4 border-green-500">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">Willingness to Pay (Parent)</h3>
                    <div class="mt-4">
                        <div class="flex justify-between mb-1">
                            <span class="text-sm font-medium text-gray-700">> ₹5000/mo</span>
                            <span class="text-sm font-medium text-gray-700">12%</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: 12%"></div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="flex justify-between mb-1">
                            <span class="text-sm font-medium text-gray-700">₹3000 - ₹5000/mo</span>
                            <span class="text-sm font-medium text-gray-700">35%</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: 35%"></div>
                        </div>
                    </div>
                </div>

                <!-- Mental Health Concern -->
                <div class="bg-white rounded-lg shadow p-6 border-t-4 border-red-500">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">Anxiety Levels (Student)</h3>
                    <p class="text-3xl font-bold text-red-600 mt-2">68%</p>
                    <p class="text-sm text-gray-500 mt-1">Students report "Often" or "Always" feeling anxious.</p>
                </div>

                <!-- NorthStar Metric -->
                <div class="bg-white rounded-lg shadow p-6 border-t-4 border-blue-500">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">NorthStar Score</h3>
                    <p class="text-3xl font-bold text-blue-600 mt-2">72.5</p>
                    <p class="text-sm text-gray-500 mt-1">Strong Market Fit (> 65)</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Types Chart
        const ctxTypes = document.getElementById('typesChart').getContext('2d');
        new Chart(ctxTypes, {
            type: 'doughnut',
            data: {
                labels: <?php echo json_encode($types_labels); ?>,
                datasets: [{
                    data: <?php echo json_encode($types_data); ?>,
                    backgroundColor: ['#3b82f6', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', '#6366f1']
                }]
            },
            options: { maintainAspectRatio: false }
        });

        // Trend Chart
        const ctxTrend = document.getElementById('trendChart').getContext('2d');
        new Chart(ctxTrend, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($trend_labels); ?>,
                datasets: [{
                    label: 'Completions',
                    data: <?php echo json_encode($trend_data); ?>,
                    borderColor: '#2563eb',
                    tension: 0.3,
                    fill: true,
                    backgroundColor: 'rgba(37, 99, 235, 0.1)'
                }]
            },
            options: { maintainAspectRatio: false }
        });
    </script>
</body>
</html>
