<?php
require_once '../includes/auth.php';
requireAdminLogin();

$success_msg = '';
$error_msg = '';

// Handle Upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['freebie_file'])) {
    $type = $_POST['freebie_type'];
    $title = $_POST['title'];
    
    $target_dir = "../public/uploads/freebies/";
    $file_extension = strtolower(pathinfo($_FILES["freebie_file"]["name"], PATHINFO_EXTENSION));
    $new_filename = $type . "_" . time() . "." . $file_extension;
    $target_file = $target_dir . $new_filename;
    
    if ($file_extension != "pdf") {
        $error_msg = "Only PDF files are allowed.";
    } else {
        if (move_uploaded_file($_FILES["freebie_file"]["tmp_name"], $target_file)) {
            // Update DB
            $stmt = $pdo->prepare("INSERT INTO digital_freebies (freebie_type, title, file_path, file_size_kb) 
                VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE title = ?, file_path = ?, file_size_kb = ?");
            
            $file_size = round($_FILES["freebie_file"]["size"] / 1024);
            $stmt->execute([$type, $title, $target_file, $file_size, $title, $target_file, $file_size]);
            
            $success_msg = "Freebie uploaded successfully!";
        } else {
            $error_msg = "Error uploading file.";
        }
    }
}

// Fetch Freebies
$stmt = $pdo->query("SELECT * FROM digital_freebies");
$freebies = $stmt->fetchAll(PDO::FETCH_GROUP|PDO::FETCH_UNIQUE);
$types = ['student_6_10', 'student_11_12', 'parent_6_10', 'parent_11_12', 'teacher', 'school_admin'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Digital Freebies - BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div class="bg-slate-800 text-white w-64 flex-shrink-0">
            <div class="p-4 text-xl font-bold border-b border-slate-700">BodhiTree Admin</div>
            <nav class="mt-4">
                <a href="dashboard.php" class="block py-3 px-4 hover:bg-slate-700">Dashboard</a>
                <a href="surveys.php" class="block py-3 px-4 hover:bg-slate-700">Surveys</a>
                <a href="analytics.php" class="block py-3 px-4 hover:bg-slate-700">Analytics</a>
                <a href="mentors.php" class="block py-3 px-4 hover:bg-slate-700">Mentors</a>
                <a href="responses.php" class="block py-3 px-4 hover:bg-slate-700">Responses</a>
                <a href="freebies.php" class="block py-3 px-4 bg-slate-700 border-l-4 border-blue-500">Freebies</a>
                <a href="logout.php" class="block py-3 px-4 hover:bg-slate-700 text-red-300">Logout</a>
            </nav>
        </div>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-8">Manage Digital Freebies</h1>

            <?php if ($success_msg): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <?php echo $success_msg; ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error_msg): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                    <?php echo $error_msg; ?>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($types as $type): ?>
                    <?php $f = $freebies[$type] ?? null; ?>
                    <div class="bg-white rounded-lg shadow p-6">
                        <h3 class="text-lg font-bold text-gray-800 mb-2"><?php echo ucwords(str_replace('_', ' ', $type)); ?></h3>
                        
                        <?php if ($f): ?>
                            <div class="mb-4">
                                <p class="text-sm text-gray-600">Current: <strong><?php echo htmlspecialchars($f['title']); ?></strong></p>
                                <p class="text-xs text-gray-400">Size: <?php echo $f['file_size_kb']; ?> KB | Updated: <?php echo date('M d', strtotime($f['updated_at'])); ?></p>
                            </div>
                        <?php else: ?>
                            <div class="mb-4 text-sm text-red-500">No freebie uploaded yet.</div>
                        <?php endif; ?>

                        <form method="POST" enctype="multipart/form-data" class="mt-4">
                            <input type="hidden" name="freebie_type" value="<?php echo $type; ?>">
                            <div class="mb-3">
                                <label class="block text-xs font-bold text-gray-700 mb-1">Title</label>
                                <input type="text" name="title" value="<?php echo $f['title'] ?? ''; ?>" required class="w-full border rounded px-2 py-1 text-sm">
                            </div>
                            <div class="mb-3">
                                <label class="block text-xs font-bold text-gray-700 mb-1">Upload PDF</label>
                                <input type="file" name="freebie_file" accept=".pdf" required class="w-full text-sm">
                            </div>
                            <button type="submit" class="w-full bg-blue-600 text-white font-bold py-2 px-4 rounded text-sm hover:bg-blue-700">
                                <?php echo $f ? 'Update Freebie' : 'Upload Freebie'; ?>
                            </button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</body>
</html>
