<?php
require_once '../includes/auth.php';
requireAdminLogin();

// Fetch Responses
$sql = "SELECT r.*, m.mentor_name 
        FROM survey_responses r 
        LEFT JOIN mentors m ON r.mentor_id = m.id 
        ORDER BY r.started_at DESC";
$stmt = $pdo->query($sql);
$responses = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Survey Responses - BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div class="bg-slate-800 text-white w-64 flex-shrink-0">
            <div class="p-4 text-xl font-bold border-b border-slate-700">BodhiTree Admin</div>
            <nav class="mt-4">
                <a href="dashboard.php" class="block py-3 px-4 hover:bg-slate-700">Dashboard</a>
                <a href="surveys.php" class="block py-3 px-4 hover:bg-slate-700">Surveys</a>
                <a href="analytics.php" class="block py-3 px-4 hover:bg-slate-700">Analytics</a>
                <a href="mentors.php" class="block py-3 px-4 hover:bg-slate-700">Mentors</a>
                <a href="responses.php" class="block py-3 px-4 bg-slate-700 border-l-4 border-blue-500">Responses</a>
                <a href="freebies.php" class="block py-3 px-4 hover:bg-slate-700">Freebies</a>
                <a href="logout.php" class="block py-3 px-4 hover:bg-slate-700 text-red-300">Logout</a>
            </nav>
        </div>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-8">
            <div class="flex justify-between items-center mb-8">
                <h1 class="text-3xl font-bold text-gray-800">Survey Responses</h1>
                <button class="bg-green-600 text-white font-bold py-2 px-4 rounded hover:bg-green-700">Export CSV</button>
            </div>

            <!-- Responses Table -->
            <div class="bg-white rounded-lg shadow overflow-hidden">
                <table class="min-w-full leading-normal">
                    <thead>
                        <tr>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Date</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Type</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Respondent</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Mentor</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Quality</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($responses as $r): ?>
                        <tr>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <p class="text-gray-900 whitespace-no-wrap"><?php echo date('M d, H:i', strtotime($r['started_at'])); ?></p>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <span class="relative inline-block px-3 py-1 font-semibold text-gray-900 leading-tight">
                                    <span aria-hidden class="absolute inset-0 bg-gray-200 opacity-50 rounded-full"></span>
                                    <span class="relative text-xs"><?php echo str_replace('_', ' ', strtoupper($r['survey_type'])); ?></span>
                                </span>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <p class="text-gray-900 whitespace-no-wrap font-bold"><?php echo htmlspecialchars($r['respondent_name']); ?></p>
                                <p class="text-gray-600 text-xs"><?php echo htmlspecialchars($r['email']); ?></p>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <p class="text-gray-900 whitespace-no-wrap"><?php echo htmlspecialchars($r['mentor_name']); ?></p>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <?php 
                                    $q_color = 'green';
                                    if ($r['quality_score'] < 0.6) $q_color = 'red';
                                    elseif ($r['quality_score'] < 0.8) $q_color = 'yellow';
                                ?>
                                <span class="relative inline-block px-3 py-1 font-semibold leading-tight text-<?php echo $q_color; ?>-900">
                                    <span aria-hidden class="absolute inset-0 bg-<?php echo $q_color; ?>-200 opacity-50 rounded-full"></span>
                                    <span class="relative"><?php echo $r['quality_score'] * 100; ?>%</span>
                                </span>
                                <?php if($r['is_bot_suspected']): ?>
                                    <span class="ml-1 text-xs text-red-600 font-bold">BOT?</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <a href="response_view.php?id=<?php echo $r['id']; ?>" class="text-blue-600 hover:text-blue-900 font-semibold">View</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
