<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid method']);
    exit;
}

$response_id = $_POST['response_id'] ?? null;
$name = $_POST['name'] ?? '';
$email = $_POST['email'] ?? '';
$phone = $_POST['phone'] ?? '';
$whatsapp_optin = $_POST['whatsapp_optin'] ?? false;

if (!$response_id) {
    echo json_encode(['success' => false, 'error' => 'Missing response ID']);
    exit;
}

$data = [
    'name' => $name,
    'email' => $email,
    'phone' => $phone
];

$result = updateRespondentInfo($response_id, $data);

if ($result) {
    // Optional: Handle WhatsApp opt-in logic here
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to update info']);
}
?>