<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';

// Mock WhatsApp API Function
function sendWhatsAppMessage($phone, $message) {
    // In a real application, this would use cURL to call the WhatsApp Business API
    // For PoC, we will simulate success and log it.
    
    $logFile = __DIR__ . '/whatsapp.log';
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] Sending to $phone: $message" . PHP_EOL;
    file_put_contents($logFile, $logEntry, FILE_APPEND);
    
    return true; // Simulate success
}

echo "Starting WhatsApp result delivery..." . PHP_EOL;

// 1. Fetch completed surveys that haven't received WhatsApp results
// Only for surveys completed > 5 minutes ago (to simulate processing time)
// and where phone number is present.
$sql = "SELECT * FROM survey_responses 
        WHERE is_completed = 1 
        AND whatsapp_results_sent = 0 
        AND phone IS NOT NULL 
        AND phone != ''
        AND completed_at < (NOW() - INTERVAL 5 MINUTE)
        LIMIT 10"; // Process in batches

$stmt = $pdo->query($sql);
$responses = $stmt->fetchAll();

echo "Found " . count($responses) . " responses to process." . PHP_EOL;

foreach ($responses as $r) {
    echo "Processing ID: " . $r['id'] . "..." . PHP_EOL;
    
    // Generate Personalized Message based on Survey Type and Quality
    $name = $r['respondent_name'] ?: "Friend";
    $message = "Hi $name! 🌟 Thank you for completing the BodhiTree survey.\n\n";
    
    if (strpos($r['survey_type'], 'student') !== false) {
        $message .= "Based on your responses, we've identified some great strengths in your focus areas! ";
        $message .= "Check out your personalized report here: " . BASE_URL . "/report.php?id=" . $r['id'];
    } else {
        $message .= "We have analyzed your inputs regarding your child's education. ";
        $message .= "Here are some insights tailored for you: " . BASE_URL . "/report.php?id=" . $r['id'];
    }
    
    $message .= "\n\nAlso, your digital freebie has been emailed to you! 🎁";

    if (sendWhatsAppMessage($r['phone'], $message)) {
        // Update DB
        $update = $pdo->prepare("UPDATE survey_responses SET whatsapp_results_sent = 1, whatsapp_sent_at = NOW() WHERE id = ?");
        $update->execute([$r['id']]);
        echo "Sent successfully." . PHP_EOL;
    } else {
        echo "Failed to send." . PHP_EOL;
    }
}

echo "Done." . PHP_EOL;
?>
