<?php
session_start();
require_once 'db.php';

function loginAdmin($username, $password) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ? AND is_active = 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_role'] = $user['role'];
        $_SESSION['admin_name'] = $user['full_name'];
        
        // Update last login
        $stmt = $pdo->prepare("UPDATE admin_users SET last_login_at = NOW() WHERE id = ?");
        $stmt->execute([$user['id']]);
        
        return true;
    }
    return false;
}

function isAdminLoggedIn() {
    return isset($_SESSION['admin_id']);
}

function requireAdminLogin() {
    if (!isAdminLoggedIn()) {
        header('Location: index.php'); // Assuming relative to admin folder
        exit;
    }
}

function loginMentor($code) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM mentors WHERE mentor_code = ? AND status = 'active'");
    $stmt->execute([$code]);
    $mentor = $stmt->fetch();
    
    if ($mentor) {
        $_SESSION['mentor_id'] = $mentor['id'];
        $_SESSION['mentor_code'] = $mentor['mentor_code'];
        $_SESSION['mentor_name'] = $mentor['mentor_name'];
        return true;
    }
    return false;
}

function isMentorLoggedIn() {
    return isset($_SESSION['mentor_id']);
}

function logout() {
    session_destroy();
    header('Location: index.php');
    exit;
}
?>
