<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';

// Get mentor code from URL
$mentor_code = $_GET['mentor'] ?? null;
$mentor = null;

if ($mentor_code) {
    $mentor = getMentorByCode($mentor_code);
}

// If no mentor or invalid code, use a system default or organic tracking
// For PoC, we'll try to find a 'system' mentor or just use the first active one, or handle null in createSurveySession
if (!$mentor) {
    // Check if a system mentor exists, otherwise create/use fallback
    $stmt = $pdo->prepare("SELECT * FROM mentors WHERE mentor_code = 'SYSTEM' LIMIT 1");
    $stmt->execute();
    $mentor = $stmt->fetch();
    
    if (!$mentor) {
        // Fallback: Use the first available mentor or create a dummy one
        $stmt = $pdo->query("SELECT * FROM mentors WHERE status = 'active' LIMIT 1");
        $mentor = $stmt->fetch();
    }
}

if (!$mentor) {
    die("System Configuration Error: No active mentor found for tracking.");
}

// Collect device fingerprint (via POST from JS)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['start_survey'])) {
    $survey_type = $_POST['survey_type'];
    $device_fingerprint = $_POST['fingerprint'];
    
    // Check if device already completed survey
    if (isDeviceCompleted($device_fingerprint)) {
        include 'views/already_completed.php';
        exit;
    }
    
    // Create session
    $session_token = createSurveySession($survey_type, $mentor['id'], $device_fingerprint);
    
    // Redirect to survey page
    header("Location: survey.php?token=$session_token");
    exit;
}

// Show landing page with survey type selection
include 'views/landing.php';
?>
