<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$response_id = $_GET['id'] ?? null;

if (!$response_id) {
    die("Invalid Report ID.");
}

$stmt = $pdo->prepare("SELECT * FROM survey_responses WHERE id = ?");
$stmt->execute([$response_id]);
$response = $stmt->fetch();

if (!$response) {
    die("Report not found.");
}

$survey_type = str_replace('_', ' ', strtoupper($response['survey_type']));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Personalized Report - BodhiTree</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700&display=swap" rel="stylesheet">
    <style>body { font-family: 'Poppins', sans-serif; }</style>
</head>
<body class="bg-gray-50 min-h-screen p-6">
    <div class="max-w-3xl mx-auto bg-white rounded-2xl shadow-xl overflow-hidden">
        <div class="bg-blue-600 p-8 text-center text-white">
            <h1 class="text-3xl font-bold mb-2">Your BodhiTree Insight Report</h1>
            <p class="opacity-90">Prepared for: <?php echo htmlspecialchars($response['respondent_name']); ?></p>
        </div>
        
        <div class="p-8">
            <div class="flex items-center justify-between mb-8 border-b pb-4">
                <div>
                    <p class="text-gray-500 text-sm">Survey Type</p>
                    <p class="font-bold text-gray-800"><?php echo $survey_type; ?></p>
                </div>
                <div>
    <p class="text-gray-500 text-sm">Date</p>
    <p class="font-bold text-gray-800"><?php echo date('M d, Y', strtotime($response['started_at'])); ?></p>
</div>
                <div>
                    <p class="text-gray-500 text-sm">Score</p>
                    <p class="font-bold text-green-600"><?php echo $response['quality_score'] * 100; ?>/100</p>
                </div>
            </div>

            <div class="space-y-6">
                <section>
                    <h2 class="text-xl font-bold text-gray-800 mb-3">Key Strengths</h2>
                    <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded">
                        <p class="text-gray-700">You demonstrated high awareness in... [Placeholder for dynamic analysis]</p>
                    </div>
                </section>

                <section>
                    <h2 class="text-xl font-bold text-gray-800 mb-3">Areas for Growth</h2>
                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded">
                        <p class="text-gray-700">Consider focusing more on... [Placeholder for dynamic analysis]</p>
                    </div>
                </section>
                
                <section class="mt-8 bg-blue-50 p-6 rounded-xl text-center">
                    <h3 class="text-lg font-bold text-blue-900 mb-2">Unlock Your Full Potential</h3>
                    <p class="text-blue-700 mb-4">Get access to our premium mentorship program.</p>
                    <a href="#" class="inline-block bg-blue-600 text-white px-8 py-3 rounded-full font-bold hover:bg-blue-700 transition">Book a Free Session</a>
                </section>
            </div>
        </div>
    </div>
</body>
</html>
