<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';
require_once '../includes/questions.php';

$session_token = $_GET['token'] ?? null;
$session = getSessionByToken($session_token);

if (!$session) {
    die("Invalid or expired session.");
}

$survey = getSurveyDetails($session['survey_type']);
$questions = getQuestions($session['survey_type']);
$total_questions = count($questions);

// Current question logic
// We'll manage the state in JS mostly, but we need the initial state
$current_q_num = $session['current_question'];

// Handle Survey Completion (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['complete_survey'])) {
    $respondent_data = [
        'name' => $_POST['name'] ?? '',
        'email' => $_POST['email'] ?? '',
        'phone' => $_POST['phone'] ?? '',
        'time_taken' => $_POST['time_taken'] ?? 0
    ];
    
    $result = completeSurvey($session_token, $respondent_data);
    
    if ($result) {
        header("Location: views/thank_you.php");
        exit;
    } else {
        $error = "There was an error saving your response. Please try again.";
    }
}

include 'views/survey_interface.php';
?>
