<?php
// Fetch active surveys
global $pdo;
$stmt = $pdo->query("SELECT * FROM surveys WHERE is_active = 1 ORDER BY id ASC");
$surveys = $stmt->fetchAll();

// Helper to guess icon
function getSurveyIcon($title) {
    $title = strtolower($title);
    if (strpos($title, 'student') !== false) return '👨‍🎓';
    if (strpos($title, 'parent') !== false) return '👨‍👩‍👧';
    if (strpos($title, 'teacher') !== false) return '👨‍🏫';
    if (strpos($title, 'school') !== false) return '🏫';
    if (strpos($title, 'admin') !== false) return '🏫';
    return '📝';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Poppins:wght@600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        h1, h2, h3, h4, h5, h6 { font-family: 'Poppins', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #2563eb 0%, #10b981 100%); }
    </style>
</head>
<body class="bg-slate-50 text-slate-800">

    <!-- Hero Section -->
    <div class="relative bg-white overflow-hidden">
        <div class="max-w-7xl mx-auto">
            <div class="relative z-10 pb-8 bg-white sm:pb-16 md:pb-20 lg:max-w-2xl lg:w-full lg:pb-28 xl:pb-32">
                <main class="mt-10 mx-auto max-w-7xl px-4 sm:mt-12 sm:px-6 md:mt-16 lg:mt-20 lg:px-8 xl:mt-28">
                    <div class="sm:text-center lg:text-left">
                        <h1 class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl">
                            <span class="block xl:inline">Help Us Build Better</span>
                            <span class="block text-blue-600 xl:inline">Education for Your Child!</span>
                        </h1>
                        <p class="mt-3 text-base text-gray-500 sm:mt-5 sm:text-lg sm:max-w-xl sm:mx-auto md:mt-5 md:text-xl lg:mx-0">
                            Your voice matters. Participate in our survey to help us understand the current challenges in education and create better solutions.
                        </p>
                    </div>
                </main>
            </div>
        </div>
    </div>

    <!-- Stakeholder Selection -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <h2 class="text-3xl font-bold text-center mb-12">Select Your Role</h2>
        
        <form id="surveyForm" method="POST" action="">
            <input type="hidden" name="start_survey" value="1">
            <input type="hidden" name="fingerprint" id="fingerprint" value="">
            <input type="hidden" name="survey_type" id="survey_type" value="">
            
            <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
                <?php if (count($surveys) > 0): ?>
                    <?php foreach ($surveys as $survey): ?>
                    <div class="bg-white rounded-xl shadow-md overflow-hidden hover:shadow-xl transition-shadow duration-300 cursor-pointer p-6 text-center border border-gray-100" onclick="selectSurvey('<?php echo htmlspecialchars($survey['slug']); ?>')">
                        <div class="text-4xl mb-4"><?php echo getSurveyIcon($survey['title']); ?></div>
                        <h3 class="text-xl font-bold text-gray-900"><?php echo htmlspecialchars($survey['title']); ?></h3>
                        <p class="mt-2 text-gray-500"><?php echo htmlspecialchars($survey['description']); ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-span-3 text-center text-gray-500 py-8">
                        No active surveys found. Please check back later.
                    </div>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Scripts -->
    <script>
        // Initialize FingerprintJS
        const fpPromise = import('https://openfpcdn.io/fingerprintjs/v4')
            .then(FingerprintJS => FingerprintJS.load());

        function selectSurvey(type) {
            fpPromise
                .then(fp => fp.get())
                .then(result => {
                    const visitorId = result.visitorId;
                    document.getElementById('fingerprint').value = visitorId;
                    document.getElementById('survey_type').value = type;
                    document.getElementById('surveyForm').submit();
                })
                .catch(error => {
                    console.error('Fingerprint generation failed:', error);
                    // Fallback to random ID to allow access if fingerprint fails
                    document.getElementById('fingerprint').value = 'fallback_' + Math.random().toString(36).substring(7);
                    document.getElementById('survey_type').value = type;
                    document.getElementById('surveyForm').submit();
                });
        }
    </script>
</body>
</html>
