<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($survey['title'] ?? 'BodhiTree Survey'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Poppins:wght@600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        h1, h2, h3, h4, h5, h6 { font-family: 'Poppins', sans-serif; }
        .slide-enter { opacity: 0; transform: translateX(20px); }
        .slide-enter-active { opacity: 1; transform: translateX(0); transition: all 0.3s ease; }
        .slide-exit { opacity: 1; transform: translateX(0); }
        .slide-exit-active { opacity: 0; transform: translateX(-20px); transition: all 0.3s ease; }
        .pulse { animation: pulse 0.8s ease-in-out; }
        @keyframes pulse {
            0% { transform: scale(0.95); opacity: 0.9; }
            100% { transform: scale(1); opacity: 1; }
        }
        .wiggle { animation: wiggle 0.6s ease-in-out; }
        @keyframes wiggle {
            0%,100% { transform: rotate(0deg); }
            25% { transform: rotate(-4deg); }
            75% { transform: rotate(4deg); }
        }
    </style>
</head>
<body class="bg-slate-50 text-slate-800 min-h-screen flex flex-col">

    <!-- Sticky Progress Bar -->
    <div class="fixed top-0 left-0 w-full bg-white/95 backdrop-blur-sm shadow-sm z-40 transition-opacity duration-300 border-b border-gray-100" id="progress-container">
        <div class="max-w-3xl mx-auto px-6 py-4">
            <div class="flex justify-between text-xs font-bold text-gray-400 uppercase tracking-wider mb-6">
                <span id="progress-text">Start</span>
                <span id="progress-percent">0%</span>
            </div>
            
            <div class="relative mx-6">
                <!-- Track -->
                <div class="w-full bg-gray-200 rounded-full h-2 relative"></div>
                
                <!-- Fill & Moving Icon -->
                <div id="progress-bar" class="absolute top-0 left-0 h-2 bg-gradient-to-r from-blue-400 to-blue-600 rounded-full transition-all duration-700 ease-out" style="width: 0%">
                    <div class="absolute right-0 top-1/2 transform translate-x-1/2 -translate-y-1/2 z-10 flex flex-col items-center group cursor-pointer">
                         <div id="gamify-emoji" class="text-4xl filter drop-shadow-lg transition-transform duration-300 transform hover:scale-125 hover:rotate-6">🌱</div>
                         <div id="gamify-label" class="absolute top-full mt-2 whitespace-nowrap text-xs font-bold text-gray-600 bg-white px-3 py-1 rounded-full shadow-md border border-gray-100 transition-all duration-300">Seedling</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-grow flex items-center justify-center pt-20 pb-12 px-4">
        <div class="w-full max-w-2xl relative">
            
            <!-- Category Selection Screen (Hidden by default) -->
            <div id="category-selection" class="hidden absolute inset-0 bg-slate-50 z-50 flex flex-col items-center justify-start pt-10">
                <div class="w-full max-w-md text-center">
                    <h2 class="text-3xl font-bold text-gray-900 mb-2"><?php echo htmlspecialchars($survey['category_label'] ?? 'Select Category'); ?></h2>
                    <p class="text-gray-600 mb-8">Please choose an option to customize your survey.</p>
                    <div class="space-y-4">
                        <?php if (!empty($survey['categories'])): ?>
                            <?php foreach ($survey['categories'] as $cat): ?>
                                <button onclick="selectCategory(<?php echo $cat['id']; ?>)" class="w-full p-5 bg-white border-2 border-gray-200 rounded-xl hover:border-blue-500 hover:bg-blue-50 hover:shadow-md transition text-lg font-semibold text-gray-700 text-left flex justify-between items-center group">
                                    <span><?php echo htmlspecialchars($cat['name']); ?></span>
                                    <span class="text-gray-400 group-hover:text-blue-500">→</span>
                                </button>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Questions Container -->
            <div id="questions-container" class="bg-white rounded-2xl shadow-lg p-6 sm:p-10 min-h-[400px] flex flex-col justify-center relative transition-opacity duration-300">
                
                <?php foreach ($questions as $index => $q): ?>
                <div class="question-slide hidden" 
                     data-original-index="<?php echo $index + 1; ?>" 
                     data-db-id="<?php echo $q['db_id']; ?>"
                     data-category-id="<?php echo $q['category_id']; ?>" 
                     data-part-id="<?php echo $q['part_id']; ?>">
                    
                    <?php if (!empty($q['part_title'])): ?>
                        <div class="inline-block px-3 py-1 bg-blue-100 text-blue-700 text-xs font-bold uppercase tracking-wider rounded-full mb-4">
                            <?php echo htmlspecialchars($q['part_title']); ?>
                        </div>
                    <?php endif; ?>

                    <h2 class="text-2xl font-bold text-gray-900 mb-8"><?php echo $q['text']; ?></h2>
                    <?php 
                        $isText = empty($q['options']);
                        $isMulti = !$isText && preg_match('/select all that apply|\\[multi\\]/i', $q['text']);
                    ?>
                    <div class="space-y-4">
                        <?php if ($isText): ?>
                            <textarea 
                                class="w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition"
                                rows="4"
                                placeholder="Your answer"
                                oninput="handleTextInput(<?php echo $q['id']; ?>, this.value)"></textarea>
                        <?php elseif ($isMulti): ?>
                            <?php foreach ($q['options'] as $optIndex => $option): ?>
                            <label class="flex items-center p-4 border-2 border-gray-100 rounded-xl cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition group">
                                <input type="checkbox" name="q<?php echo $q['id']; ?>[]" value="<?php echo htmlspecialchars($option); ?>" class="h-5 w-5 text-blue-600 border-gray-300 focus:ring-blue-500" onchange="handleMultiSelect(<?php echo $q['id']; ?>)">
                                <span class="ml-3 text-lg text-gray-700 group-hover:text-blue-700"><?php echo $option; ?></span>
                            </label>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <?php foreach ($q['options'] as $optIndex => $option): ?>
                            <label class="flex items-center p-4 border-2 border-gray-100 rounded-xl cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition group">
                                <input type="radio" name="q<?php echo $q['id']; ?>" value="<?php echo htmlspecialchars($option); ?>" class="h-5 w-5 text-blue-600 border-gray-300 focus:ring-blue-500" onchange="handleOptionSelect(<?php echo $q['id']; ?>, '<?php echo htmlspecialchars($option, ENT_QUOTES); ?>')">
                                <span class="ml-3 text-lg text-gray-700 group-hover:text-blue-700"><?php echo $option; ?></span>
                            </label>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>

                <!-- Thank You Screen (Initially Hidden) -->
                <div id="thank-you-screen" class="hidden text-center py-10">
                    <div class="text-6xl mb-6 animate-bounce">🙏</div>
                    <h2 class="text-3xl font-bold text-gray-900 mb-4 slide-enter-active">Thank you!</h2>
                    <p class="text-xl text-gray-600 leading-relaxed slide-enter-active" style="transition-delay: 0.2s">
                        <?php 
                        $thankYouMsg = !empty($survey['thank_you_message']) ? $survey['thank_you_message'] : "Thank you for your support & Commitment\ntowards Millions of Children";
                        echo nl2br(htmlspecialchars($thankYouMsg)); 
                        ?>
                    </p>
                </div>

                <!-- Contact Form (Initially Hidden) -->
                <div id="contact-form" class="hidden relative">
                    <!-- Close/Skip Button -->
                    <button type="button" onclick="skipContactForm()" class="absolute top-0 right-0 -mt-2 -mr-2 text-gray-400 hover:text-gray-600 p-2 rounded-full hover:bg-gray-100 transition" title="Skip and Finish">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>

                    <h2 class="text-2xl font-bold text-gray-900 mb-6 leading-tight pr-8">
                        <?php
                        $defaultResMsg = "Do you want to know the Results of what Thousands/lakhs of {audience} Responded?";
                        $rawMsg = !empty($survey['results_message']) ? htmlspecialchars($survey['results_message']) : $defaultResMsg;
                        // Replace {audience} with the span for JS updates
                        $finalMsg = str_replace('{audience}', '<span id="audience-type" class="text-blue-600">People</span>', $rawMsg);
                        echo $finalMsg;
                        ?>
                    </h2>
                    
                    <form id="finalForm" onsubmit="handleFinalSubmit(event)">
                        <input type="hidden" name="response_id" id="response_id" value="">
                        
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                                <input type="text" name="name" required class="w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                                <input type="email" name="email" required class="w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Phone / WhatsApp</label>
                                <input type="tel" name="phone" required class="w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition">
                            </div>
                            
                            <div class="flex items-start mt-4">
                                <div class="flex items-center h-5">
                                    <input id="whatsapp_optin" name="whatsapp_optin" type="checkbox" checked class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 rounded">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="whatsapp_optin" class="font-medium text-gray-700">Keep me updated with future surveys and results</label>
                                </div>
                            </div>
                            
                            <div class="mt-6 p-4 bg-blue-50 rounded-lg text-xs text-blue-800">
                                🔒 PRIVACY DISCLAIMER: Your data is encrypted & protected under Digital Personal Data Protection Act, 2023. Never shared with 3rd party.
                            </div>
                            
                            <div class="flex gap-3 mt-6">
                                <button type="button" onclick="skipContactForm()" class="flex-1 py-4 border-2 border-gray-200 text-gray-500 font-bold rounded-xl hover:bg-gray-50 hover:text-gray-700 transition">
                                    No Thanks
                                </button>
                                <button type="submit" class="flex-[2] bg-gradient-to-r from-blue-600 to-blue-700 text-white font-bold py-4 rounded-xl shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition duration-200">
                                    Submit & See Results
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>

            <!-- Navigation -->
            <div class="mt-8 flex justify-between" id="nav-buttons">
                <button id="prev-btn" onclick="prevQuestion()" class="px-6 py-3 rounded-lg text-gray-500 hover:text-gray-900 font-medium transition disabled:opacity-50" disabled>
                    ← Previous
                </button>
                <button id="next-btn" onclick="nextQuestion()" class="px-8 py-3 bg-blue-600 text-white rounded-lg font-bold shadow-md hover:bg-blue-700 transition">
                    Next →
                </button>
            </div>

        </div>
    </div>

    <!-- Gamification Popup -->
    <div id="milestone-popup" class="fixed inset-0 flex items-center justify-center z-50 hidden bg-black bg-opacity-50">
        <div class="bg-white rounded-2xl p-8 text-center max-w-sm mx-4 transform transition-all scale-100 animate-bounce">
            <div class="text-6xl mb-4" id="popup-emoji">🎉</div>
            <h3 class="text-2xl font-bold text-gray-900 mb-2" id="popup-title">Great Job!</h3>
            <p class="text-gray-600 mb-6" id="popup-message">You're making great progress!</p>
            <button onclick="closePopup()" class="bg-blue-600 text-white px-6 py-2 rounded-full font-bold">Continue</button>
        </div>
    </div>

    <script>
        const enableCategories = <?php echo ($survey['enable_categories'] ?? 0); ?>;
        const sessionToken = '<?php echo $session_token; ?>';
        const serverCurrentQ = <?php echo $current_q_num; ?>;
        
        let filteredQuestions = [];
        let currentIndex = 0; // Index within filteredQuestions array
        let startTime = Date.now();
        
        $(document).ready(function() {
            if (enableCategories) {
                // Check if category already selected in sessionStorage
                let savedCat = sessionStorage.getItem('survey_category_' + sessionToken);
                if (savedCat) {
                    selectCategory(savedCat);
                } else {
                    showCategorySelection();
                }
            } else {
                initQuestions();
            }
        });

        function showCategorySelection() {
            $('#category-selection').removeClass('hidden');
            $('#questions-container').addClass('opacity-0'); // Fade out effect
            $('#nav-buttons').addClass('hidden');
            $('#progress-container').addClass('hidden');
        }

        function selectCategory(catId) {
            sessionStorage.setItem('survey_category_' + sessionToken, catId);
            
            // Filter questions
            $('.question-slide').each(function() {
                let qCat = $(this).data('category-id');
                // Include if no category assigned to question OR matches selected
                // Note: qCat might be empty string or null
                if (!qCat || qCat == catId) {
                    $(this).addClass('is-visible-question');
                } else {
                    $(this).removeClass('is-visible-question');
                }
            });
            
            $('#category-selection').addClass('hidden');
            $('#questions-container').removeClass('opacity-0');
            $('#nav-buttons').removeClass('hidden');
            $('#progress-container').removeClass('hidden');
            
            initQuestions();
        }

        function initQuestions() {
            // If not using categories, all are visible
            if (!enableCategories) {
                $('.question-slide').addClass('is-visible-question');
            }
            
            filteredQuestions = $('.is-visible-question');
            
            // Resume logic: Find index in filtered list corresponding to server's current Q
            // serverCurrentQ corresponds to 'sort_order' which is data-original-index
            currentIndex = 0;
            filteredQuestions.each(function(idx) {
                if ($(this).data('original-index') == serverCurrentQ) {
                    currentIndex = idx;
                }
            });
            
            // Safety check
            if (currentIndex >= filteredQuestions.length && filteredQuestions.length > 0) {
                currentIndex = filteredQuestions.length - 1;
            }

            updateInterface();
        }

        function updateInterface() {
            // Hide all slides
            $('.question-slide').addClass('hidden');
            
            if (currentIndex < filteredQuestions.length) {
                let $q = $(filteredQuestions[currentIndex]);
                $q.removeClass('hidden');
                
                // Check if we entered a new part
                // We could show a "Part X" transition here if we wanted
                
                // Update Progress
                let pct = Math.round(((currentIndex) / filteredQuestions.length) * 100);
                $('#progress-bar').css('width', pct + '%');
                $('#progress-percent').text(pct + '%');
                $('#progress-text').text(`Question ${currentIndex + 1} of ${filteredQuestions.length}`);
                updateGamifiedProgress(pct);
                
                // Buttons
                $('#prev-btn').prop('disabled', currentIndex === 0);
                $('#nav-buttons').removeClass('hidden');
                
                // Update Next Button Text
                if (currentIndex === filteredQuestions.length - 1) {
                    $('#next-btn').text('Finish');
                    $('#next-btn').removeClass('bg-blue-600 hover:bg-blue-700').addClass('bg-green-600 hover:bg-green-700');
                } else {
                    $('#next-btn').text('Next →');
                    $('#next-btn').removeClass('bg-green-600 hover:bg-green-700').addClass('bg-blue-600 hover:bg-blue-700');
                }
            } else {
                // Done - shouldn't happen usually due to "Finish" logic, but as fallback
                showContactForm();
            }
        }
        
        function handleMultiSelect(questionId) {
             let $currentSlide = $(filteredQuestions[currentIndex]);
             let values = [];
             $currentSlide.find('input[type="checkbox"]:checked').each(function() {
                 values.push($(this).val());
             });
             if (values.length === 0) return;
             $.ajax({
                 url: '../api/save_response.php',
                 method: 'POST',
                 data: {
                     session_token: sessionToken,
                     question_num: questionId,
                     'response[]': values
                 }
             });
        }
        
        let textTimers = {};
        function handleTextInput(questionId, value) {
            if (textTimers[questionId]) {
                clearTimeout(textTimers[questionId]);
            }
            textTimers[questionId] = setTimeout(function() {
                $.post('../api/save_response.php', {
                    session_token: sessionToken,
                    question_num: questionId,
                    response: value
                });
            }, 400);
        }
        
        function handleOptionSelect(questionId, value) {
             // Auto save
             $.post('../api/save_response.php', {
                session_token: sessionToken,
                question_num: questionId, // This is the sort_order/ID
                response: value
             });
             
             // Optional: Auto-advance after delay?
             // setTimeout(nextQuestion, 500); 
        }

        function nextQuestion() {
            // Validate
            let $currentSlide = $(filteredQuestions[currentIndex]);
            let hasChecked = $currentSlide.find('input[type="radio"]:checked, input[type="checkbox"]:checked').length > 0;
            let hasText = $.trim($currentSlide.find('textarea, input[type="text"]').val() || '') !== '';
            
            if (!hasChecked && !hasText) {
                 alert("Please provide an answer to continue.");
                 return;
            }

            // Check Milestones (Gamification)
            checkMilestone(currentIndex + 1);

            if (currentIndex < filteredQuestions.length - 1) {
                currentIndex++;
                updateInterface();
                // Scroll to top
                window.scrollTo(0, 0);
            } else {
                showContactForm();
            }
        }

        function prevQuestion() {
            if (currentIndex > 0) {
                currentIndex--;
                updateInterface();
            }
        }

        function showContactForm() {
            $('#questions-container').children().addClass('hidden');
            $('#nav-buttons').addClass('hidden');
            $('#progress-bar').css('width', '100%');
            $('#progress-percent').text('100%');
            
            // Show Thank You Screen First
            $('#thank-you-screen').removeClass('hidden');
            
            // Calculate time taken
            let timeTaken = Math.round((Date.now() - startTime) / 1000);
            
            // Auto-Submit Survey (Anonymous)
            submitSurveyData(timeTaken);

            // Determine audience type (from selected category)
            let categoryName = "People"; // Default
            if (enableCategories) {
                let savedCatId = sessionStorage.getItem('survey_category_' + sessionToken);
                if (savedCatId) {
                      $('#category-selection button').each(function() {
                          if ($(this).attr('onclick').includes(savedCatId)) {
                              categoryName = $(this).find('span:first').text();
                          }
                      });
                }
            }
            $('#audience-type').text(categoryName);

            // Transition to Form after delay
            setTimeout(function() {
                $('#thank-you-screen').fadeOut(500, function() {
                    $('#contact-form').fadeIn(500).removeClass('hidden');
                });
            }, 3000); // 3 seconds delay
        }
        
        function submitSurveyData(timeTaken) {
            $.post('../api/complete_survey.php', {
                session_token: sessionToken,
                time_taken: timeTaken
            }, function(data) {
                if (data.success) {
                    $('#response_id').val(data.response_id);
                } else {
                    console.error('Failed to submit survey', data);
                }
            }, 'json');
        }
        
        function handleFinalSubmit(e) {
            e.preventDefault();
            let formData = $('#finalForm').serialize();
            
            // Disable button
            $('#finalForm button[type="submit"]').prop('disabled', true).text('Submitting...');
            
            $.post('../api/update_contact.php', formData, function(data) {
                if (data.success) {
                    window.location.href = 'views/thank_you.php';
                } else {
                    alert('Something went wrong. Please try again.');
                    $('#finalForm button[type="submit"]').prop('disabled', false).text('Submit & See Results');
                }
            }, 'json');
        }
        
        function skipContactForm() {
            window.location.href = 'views/thank_you.php';
        }


        function checkMilestone(qNum) {
            // Simple milestones based on index
            if (qNum === 5 && filteredQuestions.length > 10) showPopup("High Five! ✋", "You're doing great!");
            if (qNum === Math.floor(filteredQuestions.length / 2)) showPopup("Halfway There! 🏔️", "Keep it up!");
        }
        
        function showPopup(title, msg) {
            $('#popup-title').text(title);
            $('#popup-message').text(msg);
            $('#milestone-popup').removeClass('hidden');
        }
        
        function closePopup() {
            $('#milestone-popup').addClass('hidden');
        }
        
        const progressThemes = [
            {
                name: 'Growth', // Teachers
                stages: [
                    {t: 0, icon: '🌱', label: 'Seed'},
                    {t: 25, icon: '🌿', label: 'Sprout'},
                    {t: 50, icon: '🌳', label: 'Tree'},
                    {t: 75, icon: '🍎', label: 'Fruits'},
                    {t: 100, icon: '🧺', label: 'Harvest'}
                ]
            },
            {
                name: 'Family', // Parents
                stages: [
                    {t: 0, icon: '🐕', label: 'Puppy'},
                    {t: 33, icon: '🐕🐕', label: 'Friends'},
                    {t: 66, icon: '🐕‍🦺', label: 'Family'},
                    {t: 100, icon: '🏠', label: 'Home'}
                ]
            },
            {
                name: 'Magic', // Students
                stages: [
                    {t: 0, icon: '⚱️', label: 'Lamp'},
                    {t: 33, icon: '✨', label: 'Rubbing'},
                    {t: 66, icon: '💨', label: 'Smoke'},
                    {t: 100, icon: '🧞‍♂️', label: 'Genie'}
                ]
            },
            {
                name: 'Construction', // Schools
                stages: [
                    {t: 0, icon: '📜', label: 'Blueprint'},
                    {t: 33, icon: '🧱', label: 'Foundation'},
                    {t: 66, icon: '🏗️', label: 'Building'},
                    {t: 100, icon: '🏫', label: 'School'}
                ]
            }
        ];
        const selectedTheme = progressThemes[Math.floor(Math.random() * progressThemes.length)];
        function updateGamifiedProgress(pct) {
            let stage = selectedTheme.stages[0];
            for (let i = 0; i < selectedTheme.stages.length; i++) {
                if (pct >= selectedTheme.stages[i].t) {
                    stage = selectedTheme.stages[i];
                }
            }
            $('#gamify-emoji').text(stage.icon).addClass('pulse');
            $('#gamify-label').text(stage.label);
            setTimeout(() => $('#gamify-emoji').removeClass('pulse'), 300);
        }
    </script>
</body>
</html>
